import { DynamicModule, Module } from '@nestjs/common';
import { APP_FILTER } from '@nestjs/core';
import { BlackboxModule as BaseBlackboxModule, BlackboxAsyncOptions } from '@yandex-int/nest-infra';

import { BlackboxExceptionFilter } from './blackbox.filter';
import { BlackboxService } from './blackbox.service';

@Module({
  providers: [
    {
      provide: APP_FILTER,
      useClass: BlackboxExceptionFilter,
    },
    BlackboxService,
  ],
  exports: [BlackboxService],
})
export class BlackboxModule {
  static forRootAsync(options: BlackboxAsyncOptions): DynamicModule {
    return {
      module: BlackboxModule,
      global: true,
      imports: [BaseBlackboxModule.forRootAsync(options)],
    };
  }
}
