import { Injectable } from '@nestjs/common';
import { AsyncStorageService } from '@yandex-int/nest-common';
import { BlackboxService as BaseBlackboxService, BlackboxResult } from '@yandex-int/nest-infra';

import { BLACKBOX_ALIASES } from './blackbox.aliases';
import { BlackboxException } from './blackbox.exception';

const BLACKBOX_CACHE_KEY = Symbol('kBlackboxCache');

@Injectable()
export class BlackboxService {
  constructor(private bb: BaseBlackboxService, private storage: AsyncStorageService) {
    // @ts-expect-error: Отключаем мемоизацию метода
    this.bb.getBlackbox.disableMemoize();
  }

  async getBlackbox(shouldForceCache = false) {
    const cachedValue = this.storage.getData<BlackboxResult>(BLACKBOX_CACHE_KEY);

    if (!shouldForceCache && cachedValue) {
      return cachedValue;
    }

    const blackbox = await this.bb.getBlackbox();

    if (blackbox?.error !== 'OK') {
      throw new BlackboxException(blackbox);
    }

    this.storage.setData(BLACKBOX_CACHE_KEY, blackbox);

    return blackbox;
  }

  async isYandexoid() {
    return (await this.getBlackbox()).raw.aliases[BLACKBOX_ALIASES.yandexoid];
  }
}
