interface Service {
  ids: string[];
  iconUrl?: string;
  splashUrl?: string;
  i18nKeyName?: string;
  name: string;
  url?: string;
  help?: string;
}
export interface BunkerOhioService extends Omit<Service, 'ids'> {
  id?: string;
  alias: string;
  ids: Set<string>;
}

export interface OhioAppContext extends Pick<RawOhioBunker['config'], 'payServicesPlusPromo'> {
  services: Record<string, BunkerOhioService>;
  servicesOrder: string[];
  discounts: Set<string>;
  plusServiceData: PlusServiceDataType;
  withReceipts(id: string): boolean;
  getServiceById(id: string): BunkerOhioService | undefined;
}

interface PlusPromo {
  active: [string, string];
  label: {
    text: string;
    plusText: string;
  };
  description?: {
    text: string;
    legal: {
      text: string;
      href: string;
    };
  };
}

export interface RawOhioBunker {
  config: {
    dead?: boolean;
    services: Record<string, Service>;
    discounts: string[];
    order: string[];
    servicesIdsWithoutCheck: string[];
    plusServiceData: PlusServiceDataType;
    payServicesPlusPromo?: Record<string, PlusPromo>;
  };
  images: Record<string, string>;
}

type PlusServiceDataType = {
  serviceName: string;
  iconUrl: string;
  splashUrl: string;
};
