import {
  ReferrerHeaderOption,
  RequireTrustedTypePolicy,
  SandboxOption,
  Source,
  SriPolicy,
  TrustedTypesPolicy,
  ValidCrypto,
} from './csp-core-types';
import { CSPOptions } from './csp.interfaces';

export const SINGLE_QUOTED_SOURCES = new Set<string>([
  ReferrerHeaderOption.NO_REFERRER_WHEN_DOWNGRADE,
  ReferrerHeaderOption.NO_REFERRER,
  ReferrerHeaderOption.NONE,
  ReferrerHeaderOption.ORIGIN_WHEN_CROSS_ORIGIN,
  ReferrerHeaderOption.ORIGIN,
  ReferrerHeaderOption.SAME_ORIGIN,
  ReferrerHeaderOption.STRICT_ORIGIN_WHEN_CROSS_ORIGIN,
  ReferrerHeaderOption.STRICT_ORIGIN,
  ReferrerHeaderOption.UNSAFE_URL,
  RequireTrustedTypePolicy.SCRIPT,
  SandboxOption.ALLOW_DOWNLOADS_WITHOUT_USER_ACTIVATION,
  SandboxOption.ALLOW_FORMS,
  SandboxOption.ALLOW_MODALS,
  SandboxOption.ALLOW_ORIENTATION_LOCK,
  SandboxOption.ALLOW_POINTER_LOCK,
  SandboxOption.ALLOW_POPUPS_TO_ESCAPE_SANDBOX,
  SandboxOption.ALLOW_POPUPS,
  SandboxOption.ALLOW_PRESENTATION,
  SandboxOption.ALLOW_SAME_ORIGIN,
  SandboxOption.ALLOW_SCRIPTS,
  SandboxOption.ALLOW_STORAGE_ACCESS_BY_USER_ACTIVATION,
  SandboxOption.ALLOW_TOP_NAVIGATION_BY_USER_ACTIVATION,
  SandboxOption.ALLOW_TOP_NAVIGATION,
  Source.NONE,
  Source.REPORT_SAMPLE,
  Source.SELF,
  Source.STRICT_DYNAMIC,
  Source.UNSAFE_EVAL,
  Source.UNSAFE_HASHES,
  Source.UNSAFE_INLINE,
  SriPolicy.SCRIPT_STYLE,
  SriPolicy.SCRIPT,
  SriPolicy.STYLE,
  TrustedTypesPolicy.ALLOW_DUPLICATES,
  TrustedTypesPolicy.ANY,
  TrustedTypesPolicy.NONE,
]);

export const VALID_CRYPTO: ValidCrypto[] = ['sha256', 'sha384', 'sha512', 'nonce'];

export const CSP_OPTIONS_TOKEN = 'CSP_OPTIONS_TOKEN';

export const HEADERS = {
  CSP: 'Content-Security-Policy',
  CSP_REPORT_ONLY: 'Content-Security-Policy-Report-Only',
  REPORT_TO: 'Report-To',
};

export const DEFAULT_DOMAIN_OPTIONS = {
  // Domains from wiki/LegalDep/domain/ccTLD that are not parsed
  // by github.com/peerigon/parse-domain as TLDs by default
  customTlds: ['com.am', 'com.tc'],
};

export const DEFAULT_REPORT_GROUP = 'default-group';

export const CSP_DEFAULT_OPTIONS: CSPOptions = {};
