import { CSPHeaderParams } from 'csp-header';
import { Request, Response } from 'express';

import { ModuleMetadata, Type } from '@nestjs/common';

import { Directives, ReportTo, UrlString } from './csp-core-types';

export interface DomainOptions {
  customTlds?: string[] | RegExp;
}

export type ReportUriFunction = (req: Request, res: Response) => UrlString;

export type ReportToFunction = (req: Request, res: Response) => ReportTo[];

export interface DefaultReportUriParams {
  from?: string;
  project?: string;
}

export type CSPPresets = Record<string, Directives | undefined> | Directives[];

export interface CSPOptions {
  domainOptions?: DomainOptions;
  reportOnly?: boolean;
  presets?: CSPPresets;
  directives?: Directives;
  reportUri?: UrlString | ReportUriFunction;
  reportTo?: ReportTo[] | ReportToFunction;
  enableDefaultReportUri?: boolean;
  enableDefaultReportTo?: boolean;
  defaultReportUriParams?: DefaultReportUriParams;
}

export interface NormalizedCSPOptions extends CSPHeaderParams {
  domainOptions?: DomainOptions;
  reportOnly?: boolean;
  reportTo?: ReportTo[];
}

export interface CSPModuleOptions extends CSPOptions {
  isGlobal?: boolean;
}

export interface CSPOptionsFactory {
  createCSPOptions(): Promise<CSPOptions> | CSPOptions;
}

export interface CSPModuleAsyncOptions extends Pick<ModuleMetadata, 'imports'> {
  isGlobal?: boolean;
  useExisting?: Type<CSPOptionsFactory>;
  useClass?: Type<CSPOptionsFactory>;
  useFactory?: (...args: any[]) => Promise<CSPOptions> | CSPOptions;
  inject?: any[];
}
