import { NextFunction, Request, Response } from 'express';

import { Injectable, NestMiddleware } from '@nestjs/common';

import { CSPService } from './csp.service';

@Injectable()
export class CSPMiddleware implements NestMiddleware {
  constructor(private cspService: CSPService) {}

  async use(_req: Request, res: Response, next: NextFunction) {
    const headers = this.cspService.getHeaders();

    for (const { name, value } of headers) {
      res.setHeader(name, value);
    }

    next();
  }
}
