import { Directive, Directives, Source } from '../csp-core-types';
import { makeCspObject } from './helpers';

type RequiredDirectives = Required<Directives>;

type ValidateDirective<T, V, K> = V extends Array<infer P> ? (T extends P ? K : never) : never;

export type DirectivesByValue<T> = {
  [P in keyof RequiredDirectives]: ValidateDirective<T, RequiredDirectives[P], P>;
}[keyof Directives];

export function none(directives: DirectivesByValue<Source.NONE>[] = [Directive.DEFAULT_SRC]) {
  return makeCspObject(directives, [Source.NONE]);
}

export function unsafeInline(
  directives: DirectivesByValue<Source.UNSAFE_INLINE>[] = [
    Directive.SCRIPT_SRC,
    Directive.STYLE_SRC,
  ],
) {
  return makeCspObject(directives, [Source.UNSAFE_INLINE]);
}

export function data(directives: DirectivesByValue<Source.DATA>[] = [Directive.IMG_SRC]) {
  return makeCspObject(directives, [Source.DATA]);
}

export function blob(directives: DirectivesByValue<Source.BLOB>[] = [Directive.IMG_SRC]) {
  return makeCspObject(directives, [Source.BLOB]);
}

export function usafeEval(
  directives: DirectivesByValue<Source.UNSAFE_EVAL>[] = [Directive.SCRIPT_SRC],
) {
  return makeCspObject(directives, [Source.UNSAFE_EVAL]);
}

export function nonce(directives: DirectivesByValue<Source.NONCE>[] = [Directive.SCRIPT_SRC]) {
  return makeCspObject(directives, [Source.NONCE]);
}

export function self(
  directives: DirectivesByValue<Source.SELF>[] = [
    Directive.SCRIPT_SRC,
    Directive.STYLE_SRC,
    Directive.FONT_SRC,
    Directive.IMG_SRC,
    Directive.MEDIA_SRC,
  ],
) {
  return makeCspObject(directives, [Source.SELF]);
}
