import { Directive } from '../csp-core-types';
import { mergeDirectives } from './helpers';

export function gibdd(env = 'production') {
  const host = env === 'production' ? 'pay.yandex.ru' : 'test.pay.yandex.ru';

  return mergeDirectives([
    {
      [Directive.FRAME_SRC]: [host, 'self'],
      [Directive.IMG_SRC]: [host],
      [Directive.SCRIPT_SRC]: [host],
      [Directive.CONNECT_SRC]: [host],
    },
  ]);
}
