import { DirectiveNames, DirectiveValues, Directives } from '../csp-core-types';

function mergeDirectiveSources(a?: DirectiveValues, b?: DirectiveValues): DirectiveValues {
  if (a === undefined) {
    return b;
  }

  if (b === undefined) {
    return a;
  }

  if (Array.isArray(a) && Array.isArray(b)) {
    return Array.from(new Set([...a, ...b]));
  }

  return b;
}

export function makeCspObject<T extends DirectiveNames>(
  directiveNames: T[],
  sources: Directives[T],
) {
  const result: Directives = {};

  for (const name of directiveNames) {
    result[name] = sources;
  }

  return result;
}

export function mergeDirectives(directives: Directives[]) {
  const mergedDirectives: Directives = {};

  for (const preset of directives) {
    for (const directiveName of Object.keys(preset) as DirectiveNames[]) {
      const current = mergedDirectives[directiveName];
      const value = preset[directiveName];

      Object.assign(mergedDirectives, {
        [directiveName]: mergeDirectiveSources(current, value),
      });
    }
  }

  return mergedDirectives;
}
