import { Directive, UrlString } from '../csp-core-types';
import { AUTO_TLD } from '../csp.constants';
import { makeCspObject } from './helpers';

export function messengerFront(env?: string) {
  const host: UrlString =
    env === 'production'
      ? `https://yandex.${AUTO_TLD}/chat`
      : `https://renderer-chat-dev.hamster.yandex.${AUTO_TLD}/chat`;

  return makeCspObject([Directive.FRAME_SRC], [host]);
}
