import { Directive, Source } from '../csp-core-types';
import { blob } from './defaults';
import { mergeDirectives } from './helpers';
import { yaStatic } from './yastatic';

const WEBVISOR_HOSTS = ['mc.webvisor.com', 'mc.webvisor.org'] as const;

const ADMETRIKA_HOSTS = ['mc.admetrica.ru'] as const;

const MAIN_TLDS = ['com', 'by', 'com.tr', 'kz', 'ru', 'ua'] as const;

const EXTEND_TLDS = [
  'az',
  'co.il',
  'com.am',
  'com.ge',
  'ee',
  'fr',
  'kg',
  'lt',
  'lv',
  'md',
  'tj',
  'tm',
  'uz',
] as const;

const DEFAULT_TLDS = [...MAIN_TLDS, ...EXTEND_TLDS];

export function metrika(tlds: string[] = DEFAULT_TLDS) {
  const MC_HOSTS = tlds.map((tld) => `mc.yandex.${tld}` as const);
  const MC_WEBVISOR_HOSTS = [...WEBVISOR_HOSTS, ...MC_HOSTS];
  const MC_WEBVISOR_ADMETRIKA_HOSTS = [...MC_WEBVISOR_HOSTS, ...ADMETRIKA_HOSTS];

  return mergeDirectives([
    blob([Directive.CHILD_SRC, Directive.FRAME_SRC]),
    yaStatic([Directive.SCRIPT_SRC, Directive.IMG_SRC]),
    {
      [Directive.SCRIPT_SRC]: ['mc.yandex.ru' as const, ...MC_WEBVISOR_HOSTS],
      [Directive.IMG_SRC]: [Source.SELF, ...MC_WEBVISOR_ADMETRIKA_HOSTS],
      [Directive.CONNECT_SRC]: ['yandexmetrica.com:*', ...MC_WEBVISOR_ADMETRIKA_HOSTS],
      [Directive.CHILD_SRC]: ['mc.yandex.ru'],
      [Directive.FRAME_SRC]: ['mc.yandex.ru', 'mc.yandex.md'],
      // Подключение вебвизора по этим рекомендациям: https://clubs.at.yandex-team.ru/metrika/551
      [Directive.FRAME_ANCESTORS]: [
        'webvisor.com',
        '*.webvisor.com',
        // Карты кликов и другие карты работают из http почему то :(
        'http://webvisor.com',
        'http://*.webvisor.com',
      ],
    },
  ]);
}
