import { Directive, HostSource } from '../csp-core-types';
import { DirectivesByValue } from './defaults';
import { makeCspObject } from './helpers';

const DEFAULT_DIRECTIVES: DirectivesByValue<HostSource>[] = [
  Directive.IMG_SRC,
  Directive.MEDIA_SRC,
  Directive.FONT_SRC,
  Directive.SCRIPT_SRC,
  Directive.STYLE_SRC,
];

export function s3(
  env = 'production',
  bucket?: string,
  directives: DirectivesByValue<HostSource>[] = DEFAULT_DIRECTIVES,
) {
  const isProduction = env === 'production';
  const hosts = isProduction ? ['s3.yandex.net', 's3.mds.yandex.net'] : ['s3.mdst.yandex.net'];
  const rules = hosts.slice(0);

  if (bucket) {
    hosts.forEach((host) => {
      rules.push(`${bucket}.${host}`);
    });
  }

  return makeCspObject(directives, rules);
}
