import { Directive, HostSource } from '../csp-core-types';
import { DirectivesByValue } from './defaults';
import { makeCspObject } from './helpers';

export function yaStatic(
  directives: DirectivesByValue<HostSource>[] = [
    Directive.SCRIPT_SRC,
    Directive.STYLE_SRC,
    Directive.FONT_SRC,
    Directive.IMG_SRC,
    Directive.MEDIA_SRC,
    Directive.CONNECT_SRC,
    Directive.DEFAULT_SRC,
    Directive.FRAME_SRC,
  ],
) {
  return makeCspObject(directives, ['yastatic.net']);
}
