import { Global, Module } from '@nestjs/common';
import { ExperimentsConfigService } from '@server/config';
import { HttpModule } from '@server/shared/http';
import { CookieModule } from '@yandex-int/nest-common';

import { ExperimentsService } from './experiments.service';

@Global()
@Module({
  imports: [
    CookieModule,
    HttpModule.forRootAsync({
      useExisting: ExperimentsConfigService,
    }),
  ],
  providers: [ExperimentsService],
  exports: [ExperimentsService],
})
export class ExperimentsModule {}
