import { ModuleMetadata, Type } from '@nestjs/common';

export interface GeobaseOptions {
  /**
   * @default '/var/cache/geobase/geodata6.bin'
   */
  dataPath: string;
}

export interface GeobaseModuleOptions extends GeobaseOptions {
  isGlobal?: boolean;
}

export interface GeobaseOptionsFactory {
  createGeobaseOptions(): Promise<GeobaseOptions> | GeobaseOptions;
}

export interface GeobaseModuleAsyncOptions extends Pick<ModuleMetadata, 'imports'> {
  isGlobal?: boolean;
  useExisting?: Type<GeobaseOptionsFactory>;
  useClass?: Type<GeobaseOptionsFactory>;
  useFactory?: (...args: any[]) => Promise<GeobaseOptions> | GeobaseOptions;
  inject?: any[];
}
