import {
  Presision as GeobasePresision,
  RegionType as GeobaseRegionType,
  geobase6,
} from '@yandex-int/yandex-geobase';

export { GeobasePresision, GeobaseRegionType };

export type GeobaseGeolocationSearchData = geobase6.IGeolocationSearchData;

export type GeobaseGeolocation = geobase6.IGeolocation;

export type GeobaseGeolocationPos = geobase6.IGeolocationPos;

export type GeobaseLinguisticsItem = geobase6.ILinguisticsItem;

export type GeobaseRegion = geobase6.IRegion;

export type GeobaseReliabilityRegion = geobase6.IReliabilityRegion;

export type GeobaseTimezone = geobase6.ITimezone;

export type GeobaseTimezoneExtendedInfo = geobase6.ITimezoneExtendedInfo;

export type GeobaseIpTraits = geobase6.ITraits;

export type GeobaseAsTraits = {
  net_range: string;
  as_list: string[];
};

export type GeobaseRegionData = {
  yandexGid?: string;
  xForwardedFor?: string;
  xRealIp?: string;
};

export interface GeobaseLookupInterface {
  calcDistance(lat1: number, lon1: number, lat2: number, lon2: number): number;
  getAsNameByIp(ip: string): string;
  getAsTraitsByIp(ip: string): GeobaseAsTraits;
  getChildrenIds(id: number, domain?: string): number[] | undefined;
  getCountryId(id: number, domain?: string): number;
  getCountryRegion(regionId: number): GeobaseRegion;
  getIpTraits(ip: string): GeobaseIpTraits;
  getIspCodeByIp(ip: string): number;
  getKnownLinguistics(): string[];
  getKnownServices(): string[];
  getKnownTimezones(): GeobaseTimezoneExtendedInfo[];
  getLinguistics(id: number, language: string): GeobaseLinguisticsItem;
  getParentsIds(id: number, domain?: string): number[] | undefined;
  getRegion(yandexGid?: string, xForwardedFor?: string, xRealIp?: string): number;
  getRegionById(id: number, domain?: string): GeobaseRegion | undefined;
  getRegionByIp(ip: string, domain?: string): GeobaseRegion | undefined;
  getRegionIdByIp(ip: string): number;
  getRegionIdByLocation(lat: number, lon: number, isTune?: boolean): number;
  getRegionsByType(type: GeobaseRegionType): GeobaseRegion[];
  getReliabilitiesByIp(ip: string): GeobaseReliabilityRegion[];
  getTimezoneById(id: number): GeobaseTimezone;
  getTimezoneByLocation(lat: number, lon: number): GeobaseTimezone;
  getTimezoneByLongitude(lon: number): GeobaseTimezone;
  getTimezoneByName(name: string): GeobaseTimezone;
  getTimezoneName(id: number): string;
  haveService(id: number, serviceName: string): boolean;
  isIdInRegion(id: number, pid: number, domain?: string): boolean;
  isIpInRegion(ip: string, id: number, domain?: string): boolean;
  isTorIp(ip: string): boolean;
  makePinpointGeolocation(
    searchData: GeobaseGeolocationSearchData,
    ypCookie: string,
    ysCookie: string,
  ): GeobaseGeolocation;
}
