import { staticLogger } from '@server/shared/logger';

import { getStorageFor } from './hmr-storage.utils';

export function HmrCacheable(module: NodeModule, storageKey: string): MethodDecorator {
  return (_target, _propertyName, descriptor: PropertyDescriptor) => {
    if (module.hot && descriptor.value) {
      const storage = getStorageFor(module);
      const originalMethod = descriptor.value;

      function memoizer(this: unknown, ...args: unknown[]) {
        const storedValue = storage.get(storageKey);

        if (storedValue) {
          staticLogger.log(`Received value from cache for "${storageKey}" storage key`);

          return storedValue;
        }

        const value = originalMethod.apply(this, args);

        storage.set(storageKey, value);

        return value;
      }

      descriptor.value = memoizer;
    }
  };
}
