import { staticLogger } from '@server/shared/logger';

export class HmrStorageService extends Map<string, unknown> {
  private _module: NodeModule;

  constructor(module: NodeModule) {
    super();

    this._module = module;
    const hot = this._module.hot;

    if (hot) {
      this.restoreCache(this._module.hot?.data || {});

      hot.dispose((data: Record<string, unknown>) => {
        this.saveCache(data);
        this.clear();

        staticLogger.log(`HMR - ${module.id}: HmrStorageService disposed`);
      });

      staticLogger.log(`HMR - ${module.id}: HmrStorageService initialized`);
    }
  }

  private restoreCache(data: Record<string, unknown>) {
    const keys = Object.keys(data);

    keys.forEach((key) => {
      this.set(key, data[key]);
    });

    staticLogger.log(`Recovered keys for module: [${keys.join(', ')}]`);
  }

  private saveCache(data: Record<string, unknown>) {
    this.forEach((value, key) => {
      data[key] = value;
    });
  }
}
