import { HmrStorageService } from './hmr-storage.service';

const HMR_STORAGE_SERVICE_KEY = '__HMR_STORAGE_SERVICE_KEY';

type HmrNodeModule = NodeModule & { [HMR_STORAGE_SERVICE_KEY]?: HmrStorageService };

export function getStorageFor(module: NodeModule) {
  if (!module.hot) {
    throw new Error(
      'Hot Module Replacement (HMR) is not enabled! HmrStorageService requires HMR to function properly.',
    );
  }

  const _module = module as HmrNodeModule;

  if (!_module[HMR_STORAGE_SERVICE_KEY]) {
    _module[HMR_STORAGE_SERVICE_KEY] = new HmrStorageService(module);
  }

  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  return _module[HMR_STORAGE_SERVICE_KEY]!;
}
