import Axios from 'axios';

import { DynamicModule } from '@nestjs/common';

import { AXIOS_INSTANCE_TOKEN, AXIOS_OPTIONS_TOKEN } from './http.constants';
import { HttpModuleAsyncOptions, HttpModuleOptionsFactory } from './http.interface';
import { HttpService } from './http.service';

export class HttpModule {
  static forRootAsync(options: HttpModuleAsyncOptions): DynamicModule {
    return {
      module: HttpModule,
      providers: [
        HttpService,
        {
          provide: AXIOS_INSTANCE_TOKEN,
          useFactory: (optionsFactory: HttpModuleOptionsFactory) => {
            const config = optionsFactory.createHttpOptions();

            return Axios.create(config);
          },
          inject: [options.useExisting],
        },
        {
          provide: AXIOS_OPTIONS_TOKEN,
          useFactory: (optionsFactory: HttpModuleOptionsFactory) => {
            return optionsFactory.createHttpConfig();
          },
          inject: [options.useExisting],
        },
      ],
      exports: [HttpService],
    };
  }
}
