import { Request } from 'express';

import { ExecutionContext, createParamDecorator } from '@nestjs/common';

export type Lang = ExpressHttpLangdetect.Language;

export const LangDetect = createParamDecorator((key: 'id' | 'name', ctx: ExecutionContext) => {
  const request = ctx.switchToHttp().getRequest<Request>();
  const { langdetect } = request;

  return key ? langdetect[key] : langdetect;
});
