import { Request, Response } from 'express';

import { Injectable, NestMiddleware } from '@nestjs/common';
import { BlackboxService } from '@server/shared/blackbox';
import i18n from '@shared/i18n';
import expressHttpLangDetect from '@yandex-int/express-http-langdetect';

@Injectable()
export class LangDetectMiddleware implements NestMiddleware {
  private middleware: NestMiddleware['use'];

  constructor(private blackboxService: BlackboxService) {
    this.middleware = expressHttpLangDetect({
      availableLanguages: i18n.langs,
    });
  }

  async use(req: Request, res: Response, next: () => void) {
    const blackbox = await this.blackboxService.getBlackbox();

    // NOTE: Записываем значение в req, чтобы langdetect учитывал и значение языка из blackbox
    req.blackbox = blackbox || undefined;

    return this.middleware(req, res, next);
  }
}
