import { Global, MiddlewareConsumer, Module, NestModule } from '@nestjs/common';

import { LangDetectMiddleware } from './lang-detect.middleware';
import { LangDetectService } from './lang-detect.service';

@Global()
@Module({
  providers: [LangDetectService],
  exports: [LangDetectService],
})
export class LangDetectModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(LangDetectMiddleware).exclude('/_next/(.*)').forRoutes('*');
  }
}
