import { Injectable } from '@nestjs/common';
import { LoggerService } from '@server/shared/logger';
import { Context } from '@yandex-int/nest-common';

@Injectable()
export class LangDetectService {
  constructor(private context: Context, private logger: LoggerService) {}

  get userLang() {
    if (!this.context.req.langdetect) {
      this.logger.warn('Langdetect not inited');
    }

    return this.context.req.langdetect?.id || 'ru';
  }
}
