import { TypeMetadataStorage } from '@nestjs/graphql';

export function fromModel<T extends new () => any>(
  Model: T,
  data: Omit<InstanceType<T>, 'query'>,
): InstanceType<T> {
  const model = new Model();

  // TODO: Для обратной совместимости добавляем typename (удалить когда полностью перейдем на schema-first подход).
  if (!model.__typename) {
    const metadata = TypeMetadataStorage.getObjectTypeMetadataByTarget(Model);

    model.__typename = metadata?.name || Model.name;
  }

  Object.assign(model, data);

  return model;
}
