import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { CallHandler, ExecutionContext, Injectable, NestInterceptor } from '@nestjs/common';
import { RENDER_METADATA } from '@nestjs/common/constants';
import { LangDetectService } from '@server/shared/lang-detect';

/**
 * Для всех запросов за страницами (хендлеры с метадайтой RENDER) выставляем язык,
 * который пробросится в нативное поле locale в next
 *
 * @export
 * @class LocaleInterceptor
 * @implements {NestInterceptor}
 */
@Injectable()
export class LocaleInterceptor implements NestInterceptor {
  constructor(private langDetectService: LangDetectService) {}

  intercept(context: ExecutionContext, next: CallHandler): Observable<any> {
    return next.handle().pipe(
      map(async (value) => {
        // Является ли текущий хендлер запроса рендерером страницы
        const pageToRender = Reflect.getMetadata(RENDER_METADATA, context.getHandler());

        // если да, то берем язык и подкладываем во все данные
        if (pageToRender) {
          let userLang = 'ru';

          // уж не знаю когда такое может быть, но на всякий случай
          try {
            userLang = this.langDetectService.userLang;
          } catch (e) {}

          value.__nextLocale = userLang;
        }

        return value;
      }),
    );
  }
}
