import { Injectable } from '@nestjs/common';
import { RequestEventsMiddleware } from '@server/shared/request-events/request-events-middleware';

import { getTimeDiff } from '../stats/stat-helpers';
import { LoggerService } from './logger.service';

@Injectable()
export class LoggerMiddleware extends RequestEventsMiddleware {
  constructor(private loggerService: LoggerService) {
    super();

    this.on('start', ({ path }) => {
      this.loggerService.log('Start request', {
        path,
        ts: new Date(),
      });
    });

    this.on('finish', ({ res, start }) => {
      this.loggerService.log('Request finish', {
        ts: new Date(),
        code: res.statusCode,
        time: getTimeDiff(start),
      });
    });

    this.on('error', ({ res, start }) => {
      this.loggerService.error('Request error', {
        ts: new Date(),
        code: res.statusCode,
        time: getTimeDiff(start),
      });
    });

    this.on('close', ({ start }) => {
      this.loggerService.warn('Request closed', {
        ts: new Date(),
        code: 499,
        time: getTimeDiff(start),
      });
    });
  }
}
