import { Global, MiddlewareConsumer, Module } from '@nestjs/common';
import { RequestIdService } from '@yandex-int/nest-common';

import { LoggerMiddleware } from './logger.middleware';
import { LoggerService } from './logger.service';

@Global()
@Module({
  providers: [LoggerService],
  exports: [LoggerService],
})
export class LoggerModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(LoggerMiddleware).exclude('_next/(.*)').forRoutes('*');
  }
}
