import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { TldModule } from '@yandex-int/nest-common';
import { BlackboxModule } from '@yandex-int/nest-infra';

import { StatRequestMiddleware } from '../stats';
import { EnterGatewayMiddleware } from './enter-gateway.middleware';
import { pingController } from './ping.middleware';
import { SecurityHeadersMiddleware } from './security-headers.middleware';

@Module({
  imports: [TldModule, BlackboxModule],
})
export class MiddlewaresModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(pingController).forRoutes('/ping');

    consumer
      .apply(StatRequestMiddleware, EnterGatewayMiddleware, SecurityHeadersMiddleware)
      .exclude('_next/(.*)')
      .forRoutes('*');
  }
}
