import { NextFunction, Request, Response } from 'express';

import { Injectable, NestMiddleware } from '@nestjs/common';

@Injectable()
export class SecurityHeadersMiddleware implements NestMiddleware {
  async use(req: Request, res: Response, next: NextFunction) {
    if (!req.headers.referer || new URL(req.headers.referer).host !== req.headers.host) {
      res.setHeader('X-Frame-Options', 'DENY');
    }

    next();
  }
}
