import path from 'path';

import { loadComponents } from 'next/dist/server/load-components';

import { readDirRecursive } from './read-dir-recursive';

export async function preloadAllPagesComponents() {
  // путь к собранным файлам некста в пакете относительно текущего файла
  const nextDir = path.resolve(__dirname, '../../../../.next/');
  const pagesDir = path.join(nextDir, 'server/pages');
  const pages = readDirRecursive(pagesDir)
    // после компиляции ищем только файлы js и не начинающиеся с "_"
    .filter((filePath) => /^[a-z].*\.js$/.test(filePath))
    // отбрасываем расширение файла
    .map((filePath) => filePath.substring(0, filePath.length - 3));

  // запускаем предзагрузку всех компонент для всех страниц
  return await Promise.all(pages.map((page) => loadComponents(nextDir, page, false)));
}
