import fs from 'fs';
import path from 'path';

export function readDirRecursive(dir: string, subdir = ''): string[] {
  const items = fs.readdirSync(path.join(dir, subdir), { withFileTypes: true });
  const files = items.map((item) => {
    const res = path.join(subdir, item.name);

    return item.isDirectory() ? readDirRecursive(dir, res) : res;
  });

  // Тайпинг на flat довольно хрупкий, и тут он не понимает, что flat до бесконечности схлопнет любой вложенный массив до массива строк
  return files.flat(Infinity) as string[];
}
