import { NextFunction, Request, Response } from 'express';
import { RenderService } from 'nest-next';

import { Injectable, NestMiddleware } from '@nestjs/common';

import { NextBridgeService } from './next-bridge.service';

@Injectable()
export class NextBridgeMiddleware implements NestMiddleware {
  constructor(private renderService: RenderService, private nextBridgeService: NextBridgeService) {}

  async use(req: Request, _res: Response, next: NextFunction) {
    if (!this.renderService.isInternalUrl(req.baseUrl)) {
      (req as any).nextBridge = this.nextBridgeService;
    }

    next();
  }
}
