import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { ViewerModule } from '@server/features/viewer';
import { GraphqlModule } from '@server/infrastructure/graphql';
import { CSPModule } from '@server/shared/csp';
import { TrustModule } from '@server/shared/trust';
import { TldModule } from '@yandex-int/nest-common';

import { NextBridgeMiddleware } from './next-bridge.middleware';
import { NextBridgeService } from './next-bridge.service';

@Module({
  imports: [TldModule, GraphqlModule, ViewerModule, CSPModule, TrustModule],
  providers: [NextBridgeService],
})
export class NextBridgeModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(NextBridgeMiddleware).forRoutes('*');
  }
}
