import { staticLogger } from '@server/shared/logger';

const LOGGER_PATCHED_KEY = '__LOGGER_PATCHED_KEY';
const LOGGER_NAMESPACE = 'NextApplication';

const methods = {
  wait: 'log',
  error: 'error',
  warn: 'warn',
  ready: 'log',
  info: 'log',
  event: 'log',
  trace: 'debug',
} as const;

export function patchNextLogger() {
  try {
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    const nextLogger = require('next/dist/build/output/log');

    if (nextLogger[LOGGER_PATCHED_KEY]) {
      return;
    }
    nextLogger[LOGGER_PATCHED_KEY] = true;

    Object.entries(methods).forEach(([nextMethod, nestMethod]) => {
      nextLogger[nextMethod] = (message: string, ...messages: string[]) => {
        staticLogger[nestMethod](message, ...messages, `${LOGGER_NAMESPACE}:${nextMethod}`);
      };
    });
  } catch (err: any) {
    staticLogger.warn(`Failed to patch the next logger: ${err.message}`, { err, LOGGER_NAMESPACE });
  }
}
