import { AccountBrowser, AccountIp, AccountOs } from './shared';

export interface AppPasswordEnabledAction {
  type: 'app_passwords_enabled';
}

export interface AppPasswordsDisabledAction {
  type: 'app_passwords_disabled';
}

export interface EmailAddAction {
  type: 'email_add';
  email_bind: string;
}

export interface EmailRemoveAction {
  type: 'email_remove';
  email_unbind: string;
}

export interface EmailRemoveAllAction {
  type: 'email_remove_all';
}

export interface GlobalLogoutAction {
  type: 'global_logout';
}

export interface QuestionsChangeAction {
  type: 'questions_change';
}

export interface QuestionsRemoveAction {
  type: 'questions_remove';
}

export interface PasswordChangeAction {
  type: 'password_change';
}

export interface PasswordRemoveAction {
  type: 'password_remove';
}

export interface WebSessionsRevokedAction {
  type: 'web_sessions_revoked';
}

export interface TokensRevokedAction {
  type: 'tokens_revoked';
}

export interface AppPasswordsRevokedAction {
  type: 'app_passwords_revoked';
}

export interface PersonalDataAction {
  type: 'personal_data';
  changed_fields: Array<
    'firstname' | 'lastname' | 'display_name' | 'birthday' | 'tz' | 'country' | 'city' | 'sex'
  >;
  firstname?: string;
  lastname?: string;
  display_name?: string;
  birthday?: string;
  tz?: string;
  country?: string;
  city?: string;
  sex?: '1' | '2';
}

export interface PhoneBindAction {
  type: 'phone_bind';
  phone_bind: string;
}

export interface PhoneUnbindAction {
  type: 'phone_unbind';
  phone_unbind: string;
}

export interface SecurePhoneSetAction {
  type: 'secure_phone_set';
  phone_set: string;
}

export interface SecurePhoneReplaceAction {
  type: 'secure_phone_replace';
  phone_set: string;
  phone_unset: string;
  delayed_until?: 123456;
}

export interface SecurePhoneUnsetAction {
  type: 'secure_phone_unset';
  phone_unset: string;
  reason_uid?: 123456;
}

interface RestoreBaseAction {
  type: 'restore';
  restore_by: 'link' | 'phone_and_2fa_factor' | 'hint' | 'semi_auto';
}

interface RestoreActionByPhone {
  type: 'restore';
  restore_by: 'phone';
  phone: string;
}

interface RestoreActionByEmail {
  type: 'restore';
  restore_by: 'email';
  email: string;
}

export type RestoreAction = RestoreBaseAction | RestoreActionByPhone | RestoreActionByEmail;

export interface TotpEnabledAction {
  type: 'totp_enabled';
}

export interface TotpMigratedAction {
  type: 'totp_migrated';
}

export interface TotpDisabledAction {
  type: 'totp_disabled';
}

export type AccountEventAction =
  | AppPasswordEnabledAction
  | AppPasswordsDisabledAction
  | EmailAddAction
  | EmailRemoveAction
  | EmailRemoveAllAction
  | GlobalLogoutAction
  | QuestionsChangeAction
  | QuestionsRemoveAction
  | PasswordChangeAction
  | PasswordRemoveAction
  | WebSessionsRevokedAction
  | TokensRevokedAction
  | AppPasswordsRevokedAction
  | PersonalDataAction
  | SecurePhoneSetAction
  | SecurePhoneReplaceAction
  | SecurePhoneUnsetAction
  | RestoreAction
  | TotpEnabledAction
  | TotpMigratedAction
  | TotpDisabledAction
  | PhoneBindAction
  | PhoneUnbindAction;

export interface AccountEvent {
  event_type: string;
  ip: AccountIp;
  browser: AccountBrowser;
  os: AccountOs;
  timestamp: number;
  actions: AccountEventAction[];
}
