import { AccountBrowser, AccountIp, AccountOs } from './shared';

export interface AccountAuthentication {
  timestamp: number;
  latitude?: number;
  precision?: 'coord' | 'district' | 'region' | 'country' | 'continent';
  longitude?: number;
  accuracy?: number;
}

export type AccountAuthType =
  | 'imap'
  | 'smtp'
  | 'pop3'
  | 'xmpp'
  | 'webdav'
  | 'calendar'
  | 'web'
  | 'password-oauth';

export interface AccountAuthEvent {
  authentications: AccountAuthentication[];
  count: number;
  auth: {
    ip: AccountIp;
    authtype: AccountAuthType;
    os?: AccountOs;
    browser?: AccountBrowser;
  };
}
