interface FamilyInfo {
  admin_uid: number;
  family_id: string;
}

interface FamilyMember {
  default_avatar: string;
  display_name: string;
  has_plus: boolean;
  place_id: string;
  uid: number;
}

interface FamilyInvite {
  contact: string;
  create_time: number;
  family_id: string;
  invite_id: string;
  issuer_uid: number;
  send_method: string;
}

interface FamilyKid {
  person?: {
    birthday: string;
    country: string;
    firstname: string;
    gender: number;
    language: string;
    lastname: string;
  };
  content_rating_class: number;
  display_login: string;
  display_name?: {
    name: string;
    default_avatar: string;
  };
  music_content_rating_class: number;
  login: string;
  place_id: string;
  uid: number;
  video_content_rating_class: number;
}

interface FamilySettings {
  max_capacity: number;
  max_kids_number: number;
}

export interface FamilyData {
  account: {
    family_info?: FamilyInfo;
  };
  family_members?: FamilyMember[];
  family_invites?: FamilyInvite[];
  family_kids?: FamilyKid[];
  family_settings?: FamilySettings;
}
