export interface SendCodeToConfirmPhoneData {
  display_language?: string;
  number?: string;
  phone_id?: string;
  track_id?: string;
  country?: string;
  gps_package_name?: string;
  code_format?: string;
  route?: string;
  confirm_method?: 'by_sms' | 'by_call' | 'by_flash_call';
}

export interface SendCodeToConfirmPhoneResult {
  track_id: string;
  deny_resend_until: number;
  number: {
    original: string;
    e164: string;
    international: string;
  };
}

export interface VerifyCodeToConfirmPhoneData {
  track_id: string;
  code: string;
}

export interface VerifyCodeToConfirmPhoneResult {
  track_id: string;
}

export interface SendCodeToBindPrimaryPhoneData {
  uid?: string;
  display_language?: string;
  number: string;
  track_id?: string;
  country?: string;
  code_format?: string;
  route?: string;
}

export interface SendCodeToBindPrimaryPhoneResult {
  track_id: string;
  deny_resend_until: number;
  is_password_required: boolean;
  number: {
    original: string;
    e164: string;
    international: string;
  };
}

export interface VerifyCodeToBindPrimaryPhoneData {
  track_id: string;
  code: string;
}

export interface VerifyCodeToBindPrimaryPhoneResult {
  track_id: string;
}
