export interface IProfileUpdateParams {
  trackId?: string;
  publicId?: string;
  firstname?: string;
  lastname?: string;
  birthday?: string | null;
  gender?: string;
  country?: string;
  city?: string | null;
  timezone?: string;
  displayName?: string;
}

/**
 * Возможные поля для изменения можно смотреть по ссылке и добавлять по мере необходимости в интерфейс
 * @see https://wiki.yandex-team.ru/passport/api/bundle/changeaccount#izmenitpersonalnyedannyebandlovajaversija
 */
export interface IPassportProfileUpdate {
  track_id?: string;
  public_id?: string;
  firstname?: string;
  lastname?: string;
  birthday?: string | null;
  gender?: string;
  country?: string;
  city?: string | null;
  timezone?: string;
  display_name?: string;
}

export interface IPassportProfileUpdateResult {
  id: string;
}
