export interface SocialSubscription {
  sid: number;
  checked: boolean;
}

export interface SocialPerson {
  profile_id: number;
  email: string;
  nickname: string;
  firstname: string;
  lastname: string;
  phone_number: string;
  gender: string;
  birthday?: string | null;
}

export interface SocialProfile {
  username?: string | null;
  uid: number;
  profile_id: number;
  userid: string;
  allow_auth: boolean;
  provider: string;
  person?: SocialPerson | null;
  addresses: string[];
  subscriptions: SocialSubscription[];
  provider_code: string;
  tokens: unknown[];
  userid_map: unknown[];
  phonish?: unknown;
}
