import {
  AccountAuthEvent,
  AccountEvent,
  FamilyData,
  SendCodeToBindPrimaryPhoneResult,
  SendCodeToConfirmPhoneResult,
  SocialProfile,
  VerifyCodeToBindPrimaryPhoneResult,
  VerifyCodeToConfirmPhoneResult,
} from './api-types';
import { IPassportProfileUpdateResult } from './api-types/profile-update';
import { IPassportPublicIdValidateResult } from './api-types/public-id-validate';

export type PassportApiErrorResponse = {
  status: 'error';
  errors: string[];
};

export type PassportApiSuccessResponse<T> = T & {
  status: 'ok';
};

export type PassportApiResponse<T = {}> = PassportApiErrorResponse | PassportApiSuccessResponse<T>;

export interface LegacyPassportData {
  status: 'ok' | 'error';
  errors?: string[];
  account: {
    question?: {
      text: string;
    };
    phones: {
      [key: string]: {
        id: number;
        operation?: {
          in_quarantine: boolean;
          finished: number;
        };
      };
    };
    profiles?: {
      allow_auth: boolean;
      provider: {
        name: string;
      };
    }[];
  };
}

export type AccountEventsResponse = PassportApiResponse<{
  events: AccountEvent[];
  next_from_timestamp: number | null;
}>;

export type AccountAuthEventsResponse = PassportApiResponse<{
  events: AccountAuthEvent[];
  next_auth_row: string | null;
}>;

export type SocialProfilesInitResponse = PassportApiResponse<{
  track_id: string;
  account: unknown;
  profiles: SocialProfile[];
}>;

export type SuggestLogin = PassportApiResponse<{
  track_id: string;
  suggested_logins: string[];
}>;

export type SendCodeToConfirmPhoneResponse = PassportApiResponse<SendCodeToConfirmPhoneResult>;

export type VerifyCodeToConfirmPhoneResponse = PassportApiResponse<VerifyCodeToConfirmPhoneResult>;

export type SendCodeToBindPrimaryPhoneResponse =
  PassportApiResponse<SendCodeToBindPrimaryPhoneResult>;

export type VerifyCodeToBindPrimaryPhoneResponse =
  PassportApiResponse<VerifyCodeToBindPrimaryPhoneResult>;

export type ValidatePublicIdResponse = PassportApiResponse<IPassportPublicIdValidateResult>;

export type ProfileUpdateResponse = PassportApiResponse<IPassportProfileUpdateResult>;

type PaymentMethod = {
  id: string;
  card_id: string;
  system: string;
  number: string;
  name: string;
  proto: string;
  type: string;
  payer_info?: {
    uid?: string;
  };
};

type BillingResponse<T> = T & {
  status: 'success' | 'error';
};

export type BillingListResponse = PassportApiResponse<{
  billing_response: BillingResponse<{
    payment_methods: Record<string, PaymentMethod>;
  }>;
}>;

type Card = {
  system: string;
  number: string;
  name: string;
  id: string;
  cardId: string;
  proto: string;
  isFamilyCard: boolean;
  familyAdminUid?: number;
};

export type BillingData = {
  status: 'error' | 'success';
  cards: Card[];
  trackId: string;
};

export type CreateBindingResponse = PassportApiResponse<{
  billing_response: BillingResponse<{
    purchase_token: string;
  }>;
}>;

export type DoBindingResponse = PassportApiResponse<{
  billing_response: BillingResponse<{
    binding_form: {
      _TARGET: string;
      purchase_token: string;
    };
  }>;
}>;

export type CreateBindingProps = {
  returnPath?: string;
  lang: string;
  domainSfx: string;
  trackId: string;
  templateTag: string;
};

export type FamilyDataResponse = PassportApiResponse<FamilyData>;
