import { Module } from '@nestjs/common';
import { PassportConfigService } from '@server/config/services/passport-config.service';
import { HttpModule } from '@server/shared/http';

import { PassportPhoneService } from './passport-phone.service';
import { PassportPublicIdService } from './passport-public-id.service';
import { PassportService } from './passport.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: PassportConfigService,
    }),
  ],
  providers: [PassportService, PassportPhoneService, PassportPublicIdService],
  exports: [PassportService, PassportPhoneService, PassportPublicIdService],
})
export class PassportModule {}
