import { ModuleMetadata, Type } from '@nestjs/common';

export interface StaticMapOptions {
  host: string;
  apiKey?: string;
  secretKey?: string;
}

export interface StaticMapModuleOptions extends StaticMapOptions {
  isGlobal?: boolean;
}

export interface StaticMapOptionsFactory {
  createStaticMapOptions(): Promise<StaticMapOptions> | StaticMapOptions;
}

export interface StaticMapModuleAsyncOptions extends Pick<ModuleMetadata, 'imports'> {
  isGlobal?: boolean;
  useExisting?: Type<StaticMapOptionsFactory>;
  useClass?: Type<StaticMapOptionsFactory>;
  useFactory?: (...args: any[]) => Promise<StaticMapOptions> | StaticMapOptions;
  inject?: any[];
}
