export type StaticMapLayout = 'map' | 'sat' | 'skl' | 'trf';

export interface StaticMapCenter {
  lng: number;
  lat: number;
}

export interface StaticMapSize {
  width: number;
  height: number;
}

export interface StaticMapSpan {
  lngDiff: number;
  latDiff: number;
}

export interface StaticMapUrlOptions {
  layout?: StaticMapLayout[];
  center?: StaticMapCenter;
  zoom?: number;
  size?: StaticMapSize;
  lang?: string;
  scale?: number;
  span?: StaticMapSpan;
  colorSchema?: 'light' | 'dark';
  hideCopyright?: boolean;
  hideLogo?: boolean;
  hideText?: boolean;
}
