type KnownNames =
  | 'request.start'
  | 'request.finish'
  | 'http.success'
  | 'http.failure'
  | 'http.attempt'
  | 'http.retryRatio'
  | 'custom.sum'
  | 'custom.hist';

export interface WorkerStatMessage {
  name: KnownNames;
  payload?: {
    host?: string;
    path?: string;
    statusCode?: number;
    timedout?: boolean;
    value?: number;
    signalName?: string;
  };
}

export function statEvent(data: WorkerStatMessage) {
  (process as NodeJS.EventEmitter).emit('yasm', data);
}

// Должно отправиться WorkerStatMessage
export function statCountEvent(signalName: string, value = 1) {
  (process as NodeJS.EventEmitter).emit('yasm', {
    name: 'custom.sum',
    payload: {
      signalName,
      value,
    },
  });
}

export function statTimeEvent(signalName: string, value: number[]) {
  (process as NodeJS.EventEmitter).emit('yasm', {
    name: 'custom.hist',
    payload: {
      signalName,
      value,
    },
  });
}

export function getTimeDiff(start: bigint) {
  return Number((process.hrtime.bigint() - start) / BigInt(1_000_000));
}
