import { Injectable } from '@nestjs/common';
import { RequestEventsMiddleware } from '@server/shared/request-events/request-events-middleware';

import { getTimeDiff, statEvent } from './stat-helpers';

@Injectable()
export class StatRequestMiddleware extends RequestEventsMiddleware {
  constructor() {
    super();

    let reportStat: (code?: number) => void;

    this.on('start', ({ path, start, res }) => {
      statEvent({
        name: 'request.start',
        payload: {
          path,
        },
      });

      reportStat = (code?: number) => {
        statEvent({
          name: 'request.finish',
          payload: {
            path,
            value: getTimeDiff(start),
            statusCode: code || res.statusCode,
          },
        });
      };
    });

    this.on('finish', () => reportStat());
    this.on('error', () => reportStat(500));
    this.on('close', () => reportStat(499));
  }
}
