import { Injectable, InternalServerErrorException } from '@nestjs/common';
import { BlackboxService } from '@server/shared/blackbox';
import { HttpService } from '@server/shared/http';
import { LoggerService } from '@server/shared/logger';
import { saftyParseFloat } from '@shared/helpers';

@Injectable()
export class TrustService {
  constructor(
    private http: HttpService,
    private blackboxService: BlackboxService,
    private logger: LoggerService,
  ) {}

  /**
   * Баланс Баллов Плюса
   */
  async getPlusBalance(): Promise<string> {
    try {
      const blackbox = await this.blackboxService.getBlackbox();
      const amount = await this.http
        .get('/legacy/wallet-balance', {
          params: { uid: blackbox?.uid },
        })
        .then((response) => {
          return response.data.balances?.[0]?.amount || '0';
        })
        .catch((e) => {
          const err = e?.response?.data;

          this.logger.error('[TrustApi] getPlusBalance error', { err });
        });

      return Math.floor(saftyParseFloat(amount, 0)).toString();
    } catch (error) {
      throw new InternalServerErrorException(error);
    }
  }
}
