interface Limit {
  value: number;
  limitMode: 'DAY' | 'WEEK' | 'MONTH';
}

interface Expenses {
  amount: number;
}

interface Restriction {
  allowAllServices: boolean;
  uid: number;
  unlim: boolean;
  limitCurrency: string;
  hasSecurePhone: boolean;
  enabled: boolean;
  limit: Limit;
  expenses: Expenses;
}

interface CardInfo {
  maskedNumber: string;
  paySystem: string;
  cardId: string;
  bound: boolean;
  currency: string;
}

export interface FamilyPayData {
  adminUid: number;
  userRestrictions: Restriction[];
  properties: {
    defaultUnlim: boolean;
    limit: Limit;
    cardInfo: CardInfo;
    defaultAllowAllServices: boolean;
    origin: string;
  };
}
