import axios from 'axios';

import { Injectable } from '@nestjs/common';
import { HttpService } from '@server/shared/http';

import { FamilyPayData } from './familypay.interface';

@Injectable()
export class FamilyPayService {
  constructor(private http: HttpService) {}

  async getFamilyPayInfo(familyId: string) {
    try {
      const response = await this.http.get<FamilyPayData>(`family/${familyId}/single_limit`, {});

      return response;
    } catch (err) {
      if (axios.isAxiosError(err) && err.response?.status === 404) {
        return null;
      }

      throw err;
    }
  }
}
